#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "switchstuff.h"

char *Switchfile;
char *Tmpdir;
int Delay = 5;
int Thresh = 0;
int Show_disabled = 0;
int Show_good = 0;
int Show_worst = 0;

void
parse_args(
  int argc,
  char **argv)
{
  int c;
  extern char *optarg;

  Tmpdir = "/tmp/watchdir";

  while ((c = getopt(argc, argv, "dgT:D:s:n:w")) != EOF) switch (c) {

  case 'D':
    Tmpdir = optarg;
    break;

  case 's':	/* switch file (input) */
    Switchfile = optarg;
    break;

  case 'T':	/* reporting threshold */
    Thresh = atoi(optarg);
    break;

  case 'n':	/* inter-read delay */
    Delay = atoi(optarg);
    break;

  case 'w':
    Show_worst = 1;
    break;

  case 'd':
    Show_disabled = 1;
    break;

  case 'g':
    Show_good = 1;
    break;
  }

  /* create Tmpdir */
  if (mkdir(Tmpdir, 0755) < 0 && errno != EEXIST) {
    perror(Tmpdir);
    exit(1);
  }
}

#define CHECK_COUNTS(F,T) 					\
  do {								\
    int _p, _wp;						\
    int _sw, _wsw;						\
    int _slot, _wslot;						\
    int _d;							\
    int _worst;							\
    struct enclosure *_ep;					\
    struct slotdesc *_sp;					\
    struct xbarport *_xp;					\
    _worst = 0;							\
    for (_sw = 0; _sw < Nswitch; ++_sw) {			\
      _ep = Switch + _sw;					\
      for (_slot=0; _slot<MAX_SLOT; ++_slot) {			\
        _sp = _ep->slot[_slot];					\
	if (_sp == NULL) continue;				\
	for (_p = 0; _p < _sp->num_xp; ++_p) {			\
	  _xp = _sp->xp + _p;					\
	  _d = _xp->vals.F - _xp->old_vals.F;			\
	  if (_d > Thresh) {					\
	    printf("%s, slot %d, port %d %s delta: %d",		\
	      _ep->name, _slot, _p, T, _d);			\
	    if (_xp->fp == NULL) {				\
	      printf(" (INTERNAL)");				\
	    } else if (_xp->fp->slotno != _slot) {		\
	      printf(" (slot %d, port %d)",			\
		_xp->fp->slotno, _xp->fp->portno);		\
	    }							\
	    printf("\n");					\
	  }							\
	  if (_d > _worst) {					\
	    _worst = _d;					\
	    _wp = _p;						\
	    _wsw = _sw;						\
	    _wslot = _slot;					\
	  }							\
	}							\
      }								\
    }								\
    if (Show_worst && _worst > 0) {				\
      printf("worst %s on %s, slot %d, port %d : %d\n",		\
	T, Switch[_wsw].name, _wslot, _wp, _worst);		\
    }								\
  } while (0)

#define SHOW_DISABLED	 					\
  do {								\
    int _p;							\
    int _sw;							\
    int _slot;							\
    struct enclosure *_ep;					\
    struct slotdesc *_sp;					\
    struct xbarport *_xp;					\
    struct fiberport *_fp;					\
    for (_sw = 0; _sw < Nswitch; ++_sw) {			\
      _ep = Switch + _sw;					\
      for (_slot=0; _slot<MAX_SLOT; ++_slot) {			\
        _sp = _ep->slot[_slot];					\
	if (_sp == NULL) continue;				\
	for (_p = 0; _p < _sp->num_xp; ++_p) {			\
	  _xp = _sp->xp + _p;					\
	  if (_xp->vals.controlforxbarport != 0) {		\
	    printf("%s, slot %d, xbar port %d disabled[%d]\n",	\
	      _ep->name, _slot, _p,				\
	      _xp->vals.controlforxbarport);			\
	  }							\
	}							\
	for (_p = 0; _p < _sp->num_fiber; ++_p) {		\
	  _fp = _sp->fp + _p;					\
	  if (_fp->vals.controlforfiberport != 0) {		\
	    printf("%s, slot %d, fiber port %d disabled[%d]\n",	\
	      _ep->name, _slot, _p,				\
	      _fp->vals.controlforfiberport);			\
	  }							\
	}							\
      }								\
    }								\
  } while (0)

int
main(
  int argc,
  char **argv)
{
  parse_args(argc, argv);

  load_switch_file();
  if (Show_disabled) {
    SHOW_DISABLED;
  }

  while (1) {
    sleep(Delay);

    /* parse all enclosure files */
    parse_all_enclosures();
    
    if (Show_good) {
      CHECK_COUNTS(goodcrcs, "Good CRC Count");
    }
    CHECK_COUNTS(badcrcs, "Bad CRC Count");
    CHECK_COUNTS(receivetimeoutcount, "RX timeout Count");
    CHECK_COUNTS(transmittimeoutcount, "TX timeout Count");
    /* CHECK_COUNTS(invalidroutes, "Invalid route Count"); */
    if (Show_disabled) {
      SHOW_DISABLED;
    }
    printf("==============================\n");
  }

  return 0;
}
